<?php

use App\Http\Controllers\Controller;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     * Global mail for discussion #195,197
     *
     * @return void
     */
    public function up()
    {
        DB::beginTransaction();
        try
        {
            DB::statement("CREATE TABLE `tbk_generic_discussion` (`gdis_id` bigint(20) unsigned NOT NULL , `gdis_art_id` bigint(20) unsigned NOT NULL, `gdis_title` varchar(250) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL, `gdis_status` char(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL, `gdis_participants_by_role_id` json NOT NULL, `gdis_participants_by_usr_id` json NOT NULL, `gdis_started_by` bigint(20) unsigned DEFAULT NULL, `gdis_posted_by` bigint(20) unsigned NOT NULL, `gdis_proxy_id` bigint(20) NOT NULL, `gdis_posted_date` datetime NOT NULL, `gdis_operation` char(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL, `tbk_id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, PRIMARY KEY (`tbk_id`) ) ENGINE=InnoDB DEFAULT CHARSET=latin1");
            DB::statement("CREATE TABLE `tbk_generic_discussion_cmts` (`gdsc_id` bigint(20) unsigned NOT NULL , `gdsc_gdis_id` bigint(20) unsigned NOT NULL COMMENT 'pk of tbk_generic_discussion', `gdsc_comment` varchar(1000) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL, `gdsc_posted_by` bigint(20) unsigned NOT NULL, `gdsc_proxy_id` bigint(20) NOT NULL, `gdsc_posted_date` datetime NOT NULL, `gdsc_operation` char(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL, `tbk_id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, PRIMARY KEY (`tbk_id`) ) ENGINE=InnoDB DEFAULT CHARSET=latin1");
            DB::statement("CREATE TABLE `tbk_generic_discussion_read_status` ( `gdrs_id` bigint(20) unsigned NOT NULL, `gdrs_gdsc_id` bigint(20) unsigned NOT NULL COMMENT 'pk of tbk_generic_discussion_cmts', `gdrs_posted_by` bigint(20) unsigned NOT NULL, `gdrs_proxy_id` bigint(20) NOT NULL, `gdrs_posted_date` datetime NOT NULL, `gdrs_operation` char(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL, `tbk_id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, PRIMARY KEY (`tbk_id`) ) ENGINE=InnoDB DEFAULT CHARSET=latin1");
            DB::statement("CREATE TRIGGER trg_generic_discussion_after_insert  AFTER INSERT ON rvw_generic_discussion FOR EACH ROW INSERT INTO tbk_generic_discussion SELECT *,NULL tbk_id FROM rvw_generic_discussion WHERE gdis_id= NEW.gdis_id");
            DB::statement("CREATE TRIGGER trg_generic_discussion_after_update  AFTER UPDATE ON rvw_generic_discussion FOR EACH ROW INSERT INTO tbk_generic_discussion SELECT *,NULL tbk_id FROM rvw_generic_discussion WHERE gdis_id= OLD.gdis_id");
            DB::statement("CREATE TRIGGER trg_generic_discussion_cmts_after_insert  AFTER INSERT ON rvw_generic_discussion_cmts FOR EACH ROW INSERT INTO tbk_generic_discussion_cmts SELECT *,NULL tbk_id FROM rvw_generic_discussion_cmts WHERE gdsc_id= NEW.gdsc_id");
            DB::statement("CREATE TRIGGER trg_generic_discussion_cmts_after_update  AFTER UPDATE ON rvw_generic_discussion_cmts FOR EACH ROW INSERT INTO tbk_generic_discussion_cmts SELECT *,NULL tbk_id FROM rvw_generic_discussion_cmts WHERE gdsc_id= OLD.gdsc_id");
            DB::statement("CREATE TRIGGER trg_generic_discussion_read_status_after_insert  AFTER INSERT ON rvw_generic_discussion_read_status FOR EACH ROW INSERT INTO tbk_generic_discussion_read_status SELECT *,NULL tbk_id FROM rvw_generic_discussion_read_status WHERE gdrs_id= NEW.gdrs_id");
            DB::statement("CREATE TRIGGER trg_generic_discussion_read_status_after_update  AFTER UPDATE ON rvw_generic_discussion_read_status FOR EACH ROW INSERT INTO tbk_generic_discussion_read_status SELECT *,NULL tbk_id FROM rvw_generic_discussion_read_status WHERE gdrs_id= OLD.gdrs_id");
            DB::statement("ALTER TABLE `rvw_journal_settings` ADD `jset_reply_to_email_traction` VARCHAR(250) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL AFTER `jset_reply_to_email`");
            DB::statement("ALTER TABLE `tbk_journal_settings` ADD `jset_reply_to_email_traction` VARCHAR(250) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL DEFAULT NULL AFTER `jset_reply_to_email`");
            $client_code=(new Controller())->get_client_details('clnt_client_code');
            if($client_code->clnt_client_code=='lepra'){
                DB::insert("INSERT INTO `rvw_general_permissions` (`id`, `permission_route`, `permission_parent_route`, `permission_caption`, `permission_icon`,    `permission_roles`, `permission_posted_by`, `permission_posted_date`, `permission_proxy_id`, `permission_operation`) VALUES (NULL,'discussion-type', 'discussion-type', 'Discussion type', 'comments-o', '[\"\",\"super_admin\"]', '1', '2022-02-18 00:00:00', '0', 'u');");
            }
            DB::statement("CREATE TABLE `rvw_discussion_type`(
                `dsctp_id` BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
                `dsctp_role_id` TEXT COLLATE utf8_unicode_ci NOT NULL COMMENT 'pk of rvw_roles',
                `dsctp_type` VARCHAR(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
                `dsctp_posted_by` BIGINT(20) DEFAULT NULL,
                `dsctp_posted_date` DATETIME NOT NULL,
                `dsctp_proxy_id` BIGINT(20) DEFAULT NULL,
                `dsctp_operation` CHAR(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'u',
                PRIMARY KEY(`dsctp_id`)
            ) ENGINE = InnoDB DEFAULT CHARSET = utf8 COLLATE = utf8_unicode_ci");
            DB::statement("CREATE TABLE `tbk_discussion_type`(
                `dsctp_id` BIGINT(20) UNSIGNED NOT NULL ,
                `dsctp_role_id` TEXT COLLATE utf8_unicode_ci NOT NULL ,
                `dsctp_type` VARCHAR(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
                `dsctp_posted_by` BIGINT(20) DEFAULT NULL,
                `dsctp_posted_date` DATETIME NOT NULL,
                `dsctp_proxy_id` BIGINT(20) DEFAULT NULL,
                `dsctp_operation` CHAR(1) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT 'u',
            `tbk_id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, PRIMARY KEY (`tbk_id`)
            ) ENGINE = InnoDB DEFAULT CHARSET = utf8 COLLATE = utf8_unicode_ci");
            DB::statement("CREATE TRIGGER trg_discussion_type_after_insert  AFTER INSERT ON rvw_discussion_type FOR EACH ROW INSERT INTO tbk_discussion_type SELECT *,NULL tbk_id FROM rvw_discussion_type WHERE dsctp_id= NEW.dsctp_id");
        }
        catch (\Exception $e) {
            throw new \Exception($e->getTraceAsString());
        }
       
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tbk_generic_discussion');
        Schema::dropIfExists('tbk_generic_discussion_cmts');
        Schema::dropIfExists('tbk_generic_discussion_read_status');
        Schema::dropIfExists('rvw_discussion_type');
        Schema::dropIfExists('tbk_discussion_type');
        /*  ALTER TABLE `rvw_journal_settings` DROP `jset_reply_to_email_traction`;
            ALTER TABLE `tbk_journal_settings` DROP `jset_reply_to_email_traction`;
            DROP TRIGGER IF EXISTS `trg_generic_discussion_after_insert`;
            DROP TRIGGER IF EXISTS `trg_generic_discussion_after_update`;
            DROP TRIGGER IF EXISTS `trg_generic_discussion_cmts_after_insert`;
            DROP TRIGGER IF EXISTS `trg_generic_discussion_cmts_after_update`;
            DROP TRIGGER IF EXISTS `trg_generic_discussion_read_status_after_insert`;
            DROP TRIGGER IF EXISTS `trg_generic_discussion_read_status_after_update`; */
    }
};
